﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;
using System.Runtime.InteropServices;
namespace Helper.DBUtil
{
    [ComVisible(true)]
    public static class SqlHelper
    {
        /// <summary>
        /// 连接字符串
        /// </summary>
        public static string ConnString { get { return ConfigurationManager.ConnectionStrings["SqlServer"].ConnectionString; } }
        /// <summary>
        /// 无查询
        /// </summary>
        /// <param name="sql">SQL语句</param>
        /// <param name="pams">参数</param>
        /// <returns></returns>
        public static int Execute(string sql, params SqlParameter[] pams)
        {
            SqlConnection conn = new SqlConnection(ConnString);
            try
            {
                conn.Open();
                SqlCommand cmd = new SqlCommand(sql, conn);
                cmd.CommandTimeout = HttpHelper.TimeOut / 1000;
                foreach (var item in pams)
                {
                    cmd.Parameters.Add(item);
                }
                return cmd.ExecuteNonQuery();
            }
            catch (Exception ex)
            {
                throw;
            }
            finally
            {
                if (conn.State == ConnectionState.Open)
                { conn.Close(); }
            }
        }
        public static DataTable Quary(string sql, params SqlParameter[] pams)
        {
            try
            {
                SqlConnection conn = new SqlConnection(ConnString);
                SqlCommand cmd = new SqlCommand(sql, conn);
                foreach (var item in pams)
                {
                    cmd.Parameters.Add(item);
                }
                cmd.CommandTimeout = HttpHelper.TimeOut / 1000;
                SqlDataAdapter sda = new SqlDataAdapter(cmd);
                sda.SelectCommand.CommandTimeout = HttpHelper.TimeOut / 1000;
                DataSet ds = new DataSet();
                sda.Fill(ds);
                return ds.Tables[0];
            }
            catch (Exception ex)
            {
                throw;
                DataTable dt = new DataTable();
                dt.Columns.Add("error");
                dt.Rows.Add(ex.Message);
                return dt;
            }
        }

        public static object QuaryOne(string sql, params SqlParameter[] pams)
        {
            try
            {
                SqlConnection conn = new SqlConnection(ConnString);
                conn.Open();
                SqlCommand cmd = new SqlCommand(sql, conn);
                cmd.CommandTimeout = HttpHelper.TimeOut / 1000;
                foreach (var item in pams)
                {
                    cmd.Parameters.Add(item);
                }
                return cmd.ExecuteScalar();
            }
            catch (Exception ex)
            {
                throw;
                return ex;
            }
        }
    }
}
